/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.HeartbeatEvent;
import com.ibm.hwmca.fw.connmgr.HeartbeatListener;
import com.ibm.hwmca.fw.util.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Heartbeat
extends Thread
implements ConnectionConstants {
    private static final String THIS_CLASS = "Heartbeat";
    private List _listeners = null;
    private long _lastHeartbeatTime = new Date().getTime();
    private ContextId _clientId = null;
    private Socket _socket = null;
    private DataInputStream _in;
    private DataOutputStream _out;

    protected Heartbeat(ConnectionGroup group) throws IOException {
        this(group, new ArrayList());
    }

    protected Heartbeat(ConnectionGroup group, List listeners) throws IOException {
        super("Communications Heartbeat");
        this._clientId = group.getClientID();
        this._socket = group.getConnections()[0].getSocket();
        this._socket.setTcpNoDelay(true);
        this._socket.setSoTimeout(0);
        this._in = new DataInputStream(this._socket.getInputStream());
        this._out = new DataOutputStream(this._socket.getOutputStream());
        this._listeners = listeners;
        Trace.trace("HSSLCONF", "Heartbeat.Heartbeat:  constructor complete, client:  " + group.getClientID());
    }

    List getListeners() {
        return this._listeners;
    }

    protected ContextId getClientId() {
        return this._clientId;
    }

    public long getLastHeartbeatTime() {
        return this._lastHeartbeatTime;
    }

    protected void setLastHeartbeatTime(long time) {
        this._lastHeartbeatTime = time;
    }

    private void checkTime() throws SocketTimeoutException {
        long now = new Date().getTime();
        long elapsed = now - this.getLastHeartbeatTime();
        if (elapsed > 60000L) {
            this.fireHeartbeatEvent(null);
            if (elapsed > 240000L) {
                throw new SocketTimeoutException();
            }
        }
    }

    public void run() {
        Trace.trace("HSSLCONF", "--> Heartbeat.run, client:  " + this.getClientId());
        try {
            this._out.writeLong(this.getLastHeartbeatTime());
            while (true) {
                this.beatOnce();
                Thread.sleep(20000L);
            }
        }
        catch (Exception e) {
            this.fireHeartbeatEvent(e);
            this.cleanUp();
            Trace.trace("HSSLCONF", "<-- Heartbeat.run");
            return;
        }
    }

    void beatOnce() throws Exception {
        if (this._in.available() > 0) {
            while (this._in.available() > 0) {
                this._in.readLong();
            }
            this.setLastHeartbeatTime(new Date().getTime());
        }
        this._out.writeLong(this.getLastHeartbeatTime());
        this.checkTime();
    }

    void cleanUp() {
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._socket = null;
        this._in = null;
        this._out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireHeartbeatEvent(Exception e) {
        Trace.trace("HSSLCONF", "--> Heartbeat.fireHeartbeatEvent, exception:  " + e);
        List list = this._listeners;
        synchronized (list) {
            Iterator i = this._listeners.iterator();
            while (i.hasNext()) {
                try {
                    if (e == null) {
                        ((HeartbeatListener)i.next()).heartbeatEvent(new HeartbeatEvent(this.getLastHeartbeatTime(), this));
                        continue;
                    }
                    ((HeartbeatListener)i.next()).heartbeatException(new HeartbeatEvent(this.getLastHeartbeatTime(), this), e);
                }
                catch (ConcurrentModificationException ex) {
                    Trace.trace("HSSLCONF", "Heartbeat.fireHeartbeatEvent:  exiting to make room for transplant");
                    return;
                }
                catch (Exception ex) {
                    Trace.trace("HSSLCONF", "Heartbeat.fireHeartbeatEvent:  ", ex);
                }
            }
        }
        Trace.trace("HSSLCONF", "<-- Heartbeat.fireHeartbeatEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HeartbeatListener l) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HeartbeatListener l) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(l);
        }
    }

    public String toString() {
        return "Heartbeat, client:  " + this.getClientId();
    }
}

